function transferpara=calculatecantileversgraphs
% Calculates the transfer function for the first mode of rectangular cantilevers with
% any number of combinations of material and size parameters.
% These can be saved to an ascii file. 
% help: just follow the instructions
% uses: SaderCalcCurves.m

disp('Give parameters:')
disp('Only one set of parameters at a time! ');
disp('syntax: just type the number ');
L   =1e-6*input('length                 (microns):      ');
W   =1e-6*input('width                  (microns):      ');
t1  =1e-9*input('thickness bottom layer (NANOm)  :      ');
E1  =1e9 *input('E bot. layer           (Gpa)    :      ');
rho1=     input('rho bot. layer         (kg/m^3) :      ');
t2  =1e-9*input('thickness top layer    (NANOm  ):      ');
E2  =1e9 *input('E top layer            (Gpa)    :      ');
rho2=     input('rho top layer          (kg/m^3) :      ');
plotting= input('show plots on screen?  (1=yes)  :      ');
format=', %12.6e, %12.6e, %12.6e,%12.6e';index=', frequency    , trans_air    , trans_water  , paramvalues ';
ii=0;transferpara=0;writestring='';indexstring='';
for aa=1:length(L)
    for bb=1:length(W)
        for cc=1:length(t1)
            for dd=1:length(E1)
                for ee=1:length(rho1)
                    for ff=1:length(t2)
                        for gg=1:length(E2)
                            for hh=1:length(rho2)
                                ii=ii+1;
                                params=[L(aa),W(bb),t1(cc),E1(dd),rho1(ee),t2(ff),E2(gg),rho2(hh)];
                                curves=SaderCalcCurves(params,plotting);
                                if size(curves,1)>=size(transferpara,1) %extend vectors so they fit in with the rest  
                                   transferpara(size(curves,1),4*ii)=0;
                                   params(size(curves,1))=0 ;
                                else
                                   curves(size(transferpara,1),:)=0;
                                   params(size(transferpara,1))=0 ;   
                                end
                                transferpara(:,(4*ii-3):(4*ii))=[curves,params'];
                                if ii==1
                                    writestring='%12.6e, %12.6e, %12.6e,%12.6e';
                                    indexstring='frequency    , trans_air    , trans_water  , paramvalues '
                                else
                                    writestring=[writestring,format];
                                    indexstring=[indexstring,index];
                                end
                            end
                        end
                    end
                end
            end
        end
    end
end          
fprintf (1, 'number of curves calculated: %i . ', ii)
saver=input('Save them? (y=yes, anything else=no)  : ','s');
writestring=[writestring,'\n'];indexstring=[indexstring,'\n'];
if strcmpi(saver,'y')==1 
   flnm=input('Filename? : ','s');
   append=input('Append to existing file, if applicable? (n=create or overwrite, anything else=append)','s');
    if strcmpi(append,'n')==1 
        fid = fopen(flnm,'w');
        fprintf(fid,indexstring); 
        fprintf(fid,writestring,transferpara');
        fclose(fid)
    else 
        fid = fopen(flnm,'a');
        fprintf(fid,writestring,transferpara');
        fclose(fid)
    end
else
    disp('outcome discarded')
end
    
            